/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import android.text.TextUtils;
import com.meihu.kalle.BaseContent;
import com.meihu.kalle.Binary;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Params;
import com.meihu.kalle.RequestBody;
import com.meihu.kalle.util.IOUtils;
import com.meihu.kalle.util.LengthOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

public class FormBody
extends BaseContent<FormBody>
implements RequestBody {
    private final Charset mCharset;
    private final String mContentType;
    private final Params mParams;
    private String mBoundary;

    public static Builder newBuilder() {
        return new Builder();
    }

    private FormBody(Builder builder) {
        Object object = builder.mCharset == null ? Kalle.getConfig().getCharset() : builder.mCharset;
        this.mCharset = object;
        object = TextUtils.isEmpty((CharSequence)builder.mContentType) ? "multipart/form-data" : builder.mContentType;
        FormBody formBody = this;
        this.mContentType = object;
        formBody.mParams = builder.mParams.build();
        formBody.mBoundary = FormBody.createBoundary();
    }

    private void writeFormString(OutputStream outputStream, String string, String string2) throws IOException {
        FormBody formBody = object;
        FormBody formBody2 = object;
        FormBody formBody3 = object;
        FormBody formBody4 = object;
        FormBody formBody5 = object;
        Object object = "--" + ((FormBody)object).mBoundary + "\r\n";
        IOUtils.write(outputStream, (CharSequence)object, formBody5.mCharset);
        object = "Content-Disposition: form-data; name=\"" + string + "\"";
        IOUtils.write(outputStream, (CharSequence)object, formBody4.mCharset);
        IOUtils.write(outputStream, (CharSequence)"\r\n\r\n", formBody3.mCharset);
        IOUtils.write(outputStream, (CharSequence)string2, formBody2.mCharset);
        IOUtils.write(outputStream, (CharSequence)"\r\n", formBody.mCharset);
    }

    private void writeFormBinary(OutputStream outputStream, String string, Binary binary) throws IOException {
        OutputStream outputStream2 = outputStream;
        String string2 = "--" + this.mBoundary + "\r\n";
        IOUtils.write(outputStream, (CharSequence)string2, this.mCharset);
        string = "Content-Disposition: form-data; name=\"" + string + "\"";
        IOUtils.write(outputStream, (CharSequence)string, this.mCharset);
        string = "; filename=\"" + binary.name() + "\"";
        IOUtils.write(outputStream, (CharSequence)string, this.mCharset);
        IOUtils.write(outputStream, (CharSequence)"\r\n", this.mCharset);
        string = "Content-Type: " + binary.contentType() + "\r\n\r\n";
        IOUtils.write(outputStream2, (CharSequence)string, this.mCharset);
        if (outputStream2 instanceof LengthOutputStream) {
            ((LengthOutputStream)outputStream).write(binary.contentLength());
        } else {
            binary.writeTo(outputStream);
        }
        IOUtils.write(outputStream, (CharSequence)"\r\n", this.mCharset);
    }

    private static String createBoundary() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("-------FormBoundary");
        for (int i2 = 1; i2 < 12; ++i2) {
            long l2 = System.currentTimeMillis() + (long)i2;
            long l3 = l2 % 3L;
            if (l3 == 0L) {
                stringBuilder2.append((char)l2 % 9);
                continue;
            }
            if (l3 == 1L) {
                stringBuilder2.append((char)(l2 % 26L + 65L));
                continue;
            }
            stringBuilder2.append((char)(l2 % 26L + 97L));
        }
        return stringBuilder2.toString();
    }

    public Params copyParams() {
        return this.mParams;
    }

    @Override
    public long contentLength() {
        LengthOutputStream lengthOutputStream;
        FormBody formBody = lengthOutputStream2;
        LengthOutputStream lengthOutputStream2 = lengthOutputStream;
        lengthOutputStream = new LengthOutputStream();
        try {
            formBody.onWrite(lengthOutputStream2);
        }
        catch (IOException iOException) {}
        return lengthOutputStream2.getLength();
    }

    @Override
    public String contentType() {
        return this.mContentType + "; boundary=" + this.mBoundary;
    }

    @Override
    protected void onWrite(OutputStream outputStream) throws IOException {
        for (String string : ((FormBody)((Object)string)).mParams.keySet()) {
            for (Object object : ((FormBody)((Object)string)).mParams.get(string)) {
                if (object instanceof String) {
                    object = (String)object;
                    ((FormBody)((Object)string)).writeFormString(outputStream, string, (String)object);
                    continue;
                }
                if (!(object instanceof Binary)) continue;
                object = (Binary)object;
                super.writeFormBinary(outputStream, string, (Binary)object);
            }
        }
        FormBody formBody = string;
        IOUtils.write(outputStream, (CharSequence)"\r\n", ((FormBody)((Object)string)).mCharset);
        String string = "--" + ((FormBody)((Object)string)).mBoundary + "--\r\n";
        IOUtils.write(outputStream, (CharSequence)string, formBody.mCharset);
    }

    public static class Builder {
        private Charset mCharset;
        private String mContentType;
        private Params.Builder mParams = Params.newBuilder();

        private Builder() {
        }

        public Builder charset(Charset charset) {
            this.mCharset = charset;
            return this;
        }

        public Builder contentType(String string) {
            this.mContentType = string;
            return this;
        }

        public Builder param(String string, int n2) {
            Builder builder = this;
            builder.mParams.add(string, n2);
            return builder;
        }

        public Builder param(String string, long l2) {
            Builder builder = this;
            builder.mParams.add(string, l2);
            return builder;
        }

        public Builder param(String string, boolean bl) {
            Builder builder = this;
            builder.mParams.add(string, bl);
            return builder;
        }

        public Builder param(String string, char c2) {
            Builder builder = this;
            builder.mParams.add(string, c2);
            return builder;
        }

        public Builder param(String string, double d2) {
            Builder builder = this;
            builder.mParams.add(string, d2);
            return builder;
        }

        public Builder param(String string, float f2) {
            Builder builder = this;
            builder.mParams.add(string, f2);
            return builder;
        }

        public Builder param(String string, short s2) {
            Builder builder = this;
            builder.mParams.add(string, s2);
            return builder;
        }

        public Builder param(String string, CharSequence charSequence) {
            Builder builder = this;
            builder.mParams.add(string, charSequence);
            return builder;
        }

        public Builder param(String string, String string2) {
            Builder builder = this;
            builder.mParams.add(string, string2);
            return builder;
        }

        public Builder param(String string, List<String> list) {
            Builder builder = this;
            builder.mParams.add(string, list);
            return builder;
        }

        public Builder params(Params params) {
            Builder builder = this;
            builder.mParams.add(params);
            return builder;
        }

        public Builder file(String string, File file) {
            Builder builder = this;
            builder.mParams.file(string, file);
            return builder;
        }

        public Builder files(String string, List<File> list) {
            Builder builder = this;
            builder.mParams.files(string, list);
            return builder;
        }

        public Builder binary(String string, Binary binary) {
            Builder builder = this;
            builder.mParams.binary(string, binary);
            return builder;
        }

        public Builder binaries(String string, List<Binary> list) {
            Builder builder = this;
            builder.mParams.binaries(string, list);
            return builder;
        }

        public Builder removeParam(String string) {
            Builder builder = this;
            builder.mParams.remove(string);
            return builder;
        }

        public Builder clearParams() {
            Builder builder = this;
            builder.mParams.clear();
            return builder;
        }

        public FormBody build() {
            return new FormBody(this);
        }
    }
}

