/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.utils;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ThemisUtil {
    public static final String TAG = "Themis";
    public static final int DEVICE_LEVEL_HIGH = 2;
    public static final int DEVICE_LEVEL_MID = 1;
    public static final int DEVICE_LEVEL_LOW = 0;
    public static final int DEVICE_LEVEL_UNKNOWN = -1;
    public static final int DEVICEINFO_UNKNOWN = -1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i2 = 3; i2 < string.length(); ++i2) {
                    if (Character.isDigit(string.charAt(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    /*
     * Loose catch block
     */
    @TargetApi(value=16)
    public static long getTotalMemory(Context object) {
        FileInputStream fileInputStream;
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memoryInfo;
            Context context = object;
            object = memoryInfo;
            memoryInfo = new ActivityManager.MemoryInfo();
            ((ActivityManager)context.getSystemService("activity")).getMemoryInfo((ActivityManager.MemoryInfo)object);
            return ((ActivityManager.MemoryInfo)object).totalMem;
        }
        long l2 = -1L;
        object = fileInputStream;
        fileInputStream = new FileInputStream("/proc/meminfo");
        l2 = (long)ThemisUtil.parseFileForValue("MemTotal", (FileInputStream)object) * 1024L;
        fileInputStream.close();
        catch (Throwable throwable) {
            try {
                ((FileInputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return l2;
    }

    /*
     * Unable to fully structure code
     */
    public static int getCPUMaxFreqKHz() {
        block30: {
            block29: {
                var0 = -1;
                var1_3 = 0;
                while (true) {
                    block27: {
                        block28: {
                            if (var1_3 >= ThemisUtil.getNumberOfCPUCores()) break;
                            var2_5 = "/sys/devices/system/cpu/cpu" + var1_3 + "/cpufreq/cpuinfo_max_freq";
                            var3_9 = v0;
                            if (!new File(var2_5).exists()) break block27;
                            if (!var3_9.canRead()) break block27;
                            var2_6 = 128;
                            var4_11 = new byte[128];
                            var5_12 = v1;
                            v1 = new FileInputStream(var3_9);
                            v1.read(var4_11);
                            var3_10 = 0;
                            while (true) {
                                if (!Character.isDigit(var4_11[var3_10]) || var3_10 >= var2_6) break;
                                ++var3_10;
                                continue;
                                break;
                            }
                            var2_7 = Integer.parseInt(new String(var4_11, 0, var3_10));
                            if (var2_7 <= var0) break block28;
                            try {
                                var0 = var2_7;
                            }
                            catch (Throwable var0_1) {
                                var5_12.close();
                                throw var0_1;
                            }
                            catch (NumberFormatException v2) {
                                ** continue;
                            }
                        }
lbl35:
                        // 2 sources

                        while (true) {
                            var5_12.close();
                            break;
                        }
                    }
                    ++var1_3;
                }
                if (var0 != -1) break block30;
                var1_4 = v3;
                v3 = new FileInputStream("/proc/cpuinfo");
                var2_8 = ThemisUtil.parseFileForValue("cpu MHz", var1_4) * 1000;
                if (var2_8 <= var0) break block29;
                var0 = var2_8;
            }
            var1_4.close();
            catch (Throwable var0_2) {
                var1_4.close();
                throw var0_2;
                {
                    catch (IOException v4) {
                        var0 = -1;
                    }
                }
            }
        }
        return var0;
    }

    public static int getNumberOfCPUCores() {
        int n2;
        block7: {
            block6: {
                if (Build.VERSION.SDK_INT <= 10) {
                    return 1;
                }
                n2 = ThemisUtil.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
                if (n2 != -1) break block6;
                n2 = ThemisUtil.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (n2 != -1) break block7;
            try {
                n2 = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
                break block7;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {}
            n2 = -1;
        }
        return n2;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static int getCoresFromFileInfo(String object) {
        InputStream inputStream;
        block17: {
            void var0_4;
            block16: {
                BufferedReader bufferedReader;
                FileInputStream fileInputStream;
                inputStream = null;
                FileInputStream fileInputStream2 = fileInputStream;
                fileInputStream = new FileInputStream((String)object);
                object = bufferedReader;
                String string = new BufferedReader(new InputStreamReader(fileInputStream2)).readLine();
                ((BufferedReader)object).close();
                int n2 = ThemisUtil.getCoresFromFileString(string);
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
                return n2;
                catch (Throwable throwable) {
                    inputStream = fileInputStream2;
                    break block16;
                }
                catch (IOException iOException) {
                    inputStream = fileInputStream2;
                    break block17;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw var0_4;
            catch (IOException iOException) {}
        }
        int n3 = -1;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return n3;
    }

    private static int getCoresFromFileString(String string) {
        if (string != null && string.matches("0-[\\d]+$")) {
            return Integer.valueOf(string.substring(2)) + 1;
        }
        return -1;
    }

    private static int parseFileForValue(String string, FileInputStream object) {
        Object object2 = object;
        byte[] byArray = new byte[1024];
        object = byArray;
        int n2 = ((FileInputStream)object2).read(byArray);
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            reference var4_4;
            block9: {
                try {
                    var4_4 = object[i2];
                    if (var4_4 != 10 && i2 != 0) continue;
                    if (var4_4 != 10) break block9;
                    ++i2;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                catch (IOException iOException) {}
            }
            var4_4 = (reference)i2;
            while (var4_4 < n2) {
                reference v2 = var4_4++;
                reference var5_5 = v2 - i2;
                if (object[v2] != string.charAt((int)var5_5)) continue block7;
                if (var5_5 != string.length() - 1) continue;
                return ThemisUtil.extractValue((byte[])object, (int)var4_4);
            }
            continue;
            break;
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n2) {
        int n3;
        while (n2 < byArray.length && (n3 = byArray[n2]) != 10) {
            if (Character.isDigit(n3)) {
                for (n3 = n2 + 1; n3 < byArray.length && Character.isDigit(byArray[n3]); ++n3) {
                }
                int n4 = n3 - n2;
                return Integer.parseInt(new String(byArray, 0, n2, n4));
            }
            ++n2;
        }
        return -1;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        context = memoryInfo;
        activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
        return context.availMem;
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getHardWare() {
        block9: {
            BufferedReader bufferedReader;
            FileReader fileReader;
            Object object = fileReader;
            fileReader = new FileReader("/proc/cpuinfo");
            BufferedReader bufferedReader2 = bufferedReader;
            bufferedReader = new BufferedReader((Reader)object);
            object = "";
            while (true) {
                String string = bufferedReader2.readLine();
                if (string == null) break;
                object = string;
                continue;
                break;
            }
            if (!((String)object).contains("Hardware")) break block9;
            try {
                return ((String)object).split(":\\s+", 2)[1];
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return Build.HARDWARE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int judgeDeviceLevel(Context context) {
        int n2 = -1;
        int n3 = ThemisUtil.judgeMemory(context);
        int n4 = ThemisUtil.judgeCPU();
        if (n3 == 0) return 0;
        if (n3 == 1) return 0;
        if (n4 == 0) return 0;
        if (n3 == 2 && n4 >= 1) {
            return 1;
        }
        if (n3 <= 2) return n2;
        if (n4 <= 1) return 1;
        return 2;
    }

    private static int judgeMemory(Context context) {
        long l2 = ThemisUtil.getTotalMemory(context) / 0x100000L;
        return l2 <= 2000L ? 0 : (l2 <= 3000L ? 1 : (l2 <= 4000L ? 2 : (l2 <= 6000L ? 3 : 4)));
    }

    private static int judgeCPU() {
        ThemisUtil.getHardWare();
        int n2 = ThemisUtil.getCPUMaxFreqKHz() / 1000;
        return n2 <= 1600 ? 0 : (n2 <= 2000 ? 1 : (n2 <= 2500 ? 2 : 3));
    }
}

