/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.filter.glfilter.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.text.TextUtils;
import com.meihu.beautylibrary.utils.c;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;

public class OpenGLUtils {
    public static final String TAG = "OpenGLUtils";
    public static final int GL_NOT_INIT = -1;
    public static final int GL_NOT_TEXTURE = -1;
    public static final float[] IDENTITY_MATRIX = new float[16];
    private static final int SIZEOF_FLOAT = 4;
    private static final int SIZEOF_SHORT = 2;

    private OpenGLUtils() {
    }

    public static String getShaderFromFile(String object) {
        FileInputStream fileInputStream;
        File file;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        File file2 = file;
        if (new File((String)object).isDirectory()) {
            return null;
        }
        object = null;
        FileInputStream fileInputStream2 = fileInputStream;
        try {
            fileInputStream = new FileInputStream(file2);
            object = fileInputStream2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return OpenGLUtils.getShaderStringFromStream((InputStream)object);
    }

    public static String getShaderFromAssets(Context object, String string) {
        Context context = object;
        object = null;
        try {
            object = context.getResources().getAssets().open(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return OpenGLUtils.getShaderStringFromStream((InputStream)object);
    }

    /*
     * Unable to fully structure code
     */
    private static String getShaderStringFromStream(InputStream var0) {
        if (var0 == null) {
            return null;
        }
        var1_1 = v0;
        var2_2 = v1;
        v1 = new InputStreamReader((InputStream)var0);
        v0 = new BufferedReader((Reader)var2_2);
        var0 = v2;
        try {
            v2 = new StringBuilder();
            ** while ((var2_2 = var1_1.readLine()) != null)
        }
        catch (IOException v3) {
            v3.printStackTrace();
            return null;
        }
lbl-1000:
        // 1 sources

        {
            var0.append((String)var2_2).append("\n");
            continue;
        }
lbl20:
        // 2 sources

        var1_1.close();
        return var0.toString();
    }

    public static int createProgram(String string, String string2) {
        int n2 = OpenGLUtils.loadShader(35633, string);
        if (n2 == 0) {
            return 0;
        }
        int n3 = OpenGLUtils.loadShader(35632, string2);
        if (n3 == 0) {
            return 0;
        }
        int n4 = GLES20.glCreateProgram();
        OpenGLUtils.checkGlError("glCreateProgram");
        GLES20.glAttachShader((int)n4, (int)n2);
        OpenGLUtils.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)n4, (int)n3);
        OpenGLUtils.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)n4);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            int n5 = n4;
            GLES20.glGetProgramInfoLog((int)n5);
            GLES20.glDeleteProgram((int)n5);
            n4 = 0;
        }
        return n4;
    }

    public static int loadShader(int n2, String object) {
        int n3 = GLES20.glCreateShader((int)n2);
        OpenGLUtils.checkGlError("glCreateShader type=" + n2);
        GLES20.glShaderSource((int)n3, (String)object);
        GLES20.glCompileShader((int)n3);
        int[] nArray = new int[1];
        object = nArray;
        GLES20.glGetShaderiv((int)n3, (int)35713, (int[])object, (int)0);
        if (nArray[0] == 0) {
            new StringBuilder().append("Could not compile shader ").append(n2).append(":");
            new StringBuilder().append(" ").append(GLES20.glGetShaderInfoLog((int)n3));
            GLES20.glDeleteShader((int)n3);
            n3 = 0;
        }
        return n3;
    }

    public static void checkGlError(String string) {
        int n2 = GLES20.glGetError();
        if (n2 == 0) {
            return;
        }
        string = string + ": glError 0x" + Integer.toHexString(n2);
        throw new RuntimeException(string);
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static FloatBuffer createFloatBuffer(ArrayList<Float> arrayList) {
        int n2 = arrayList.size();
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = arrayList.get(i2).floatValue();
        }
        return OpenGLUtils.createFloatBuffer(fArray);
    }

    public static ShortBuffer createShortBuffer(short[] sArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(sArray.length * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        shortBuffer.put(sArray);
        shortBuffer.position(0);
        return shortBuffer;
    }

    public static ShortBuffer createShortBuffer(ArrayList<Short> arrayList) {
        int n2 = arrayList.size();
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = arrayList.get(i2);
        }
        return OpenGLUtils.createShortBuffer(sArray);
    }

    public static void createFrameBuffer(int[] nArray, int[] nArray2, int n2, int n3) {
        GLES20.glGenFramebuffers((int)nArray.length, (int[])nArray, (int)0);
        GLES20.glGenTextures((int)nArray2.length, (int[])nArray2, (int)0);
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            GLES20.glBindTexture((int)3553, (int)nArray2[i2]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n2, (int)n3, (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)nArray[i2]);
            int n4 = nArray2[i2];
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n4, (int)0);
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
        OpenGLUtils.checkGlError("createFrameBuffer");
    }

    public static int createTexture(int n2) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        OpenGLUtils.checkGlError("glGenTextures");
        int n3 = nArray[0];
        int n4 = n2;
        GLES20.glBindTexture((int)n4, (int)n3);
        OpenGLUtils.checkGlError("glBindTexture " + n3);
        GLES20.glTexParameterf((int)n4, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)n4, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n4, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n4, (int)10243, (float)33071.0f);
        OpenGLUtils.checkGlError("glTexParameter");
        return n3;
    }

    public static int createTexture(Bitmap bitmap) {
        int[] nArray = new int[1];
        if (bitmap != null && !bitmap.isRecycled()) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            OpenGLUtils.checkGlError("glGenTexture");
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            return nArray[0];
        }
        return 0;
    }

    public static int createTexture(Bitmap bitmap, int n2) {
        int[] nArray = new int[1];
        if (n2 == -1) {
            nArray[0] = OpenGLUtils.createTexture(bitmap);
        } else {
            nArray[0] = n2;
            if (bitmap != null && !bitmap.isRecycled()) {
                GLES20.glBindTexture((int)3553, (int)nArray[0]);
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            }
        }
        return nArray[0];
    }

    public static int createTexture(byte[] byArray, int n2, int n3) {
        return OpenGLUtils.createTexture(byArray, n2, n3, -1);
    }

    public static int createTexture(byte[] byArray, int n2, int n3, int n4) {
        if (byArray.length == n2 * n3 * 4) {
            return OpenGLUtils.createTexture(ByteBuffer.wrap(byArray), n2, n3, n4);
        }
        throw new RuntimeException("Illegal byte array");
    }

    public static int createTexture(ByteBuffer byteBuffer, int n2, int n3) {
        if (byteBuffer.array().length == n2 * n3 * 4) {
            int[] nArray = new int[1];
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            int n4 = nArray[0];
            if (n4 == 0) {
                return 0;
            }
            GLES20.glBindTexture((int)3553, (int)n4);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n2, (int)n3, (int)0, (int)6408, (int)5121, (Buffer)byteBuffer);
            GLES20.glBindTexture((int)3553, (int)0);
            return nArray[0];
        }
        throw new RuntimeException("Illegal byte array");
    }

    public static int createTexture(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        if (byteBuffer.array().length == n2 * n3 * 4) {
            if (n4 == -1) {
                return OpenGLUtils.createTexture(byteBuffer, n2, n3);
            }
            GLES20.glBindTexture((int)3553, (int)n4);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n2, (int)n3, (int)6408, (int)5121, (Buffer)byteBuffer);
            return n4;
        }
        throw new RuntimeException("Illegal byte array");
    }

    public static int createTexture(String string) {
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = -1;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -1;
        }
        GLES20.glGenTextures((int)1, (int[])nArray2, (int)0);
        if (nArray2[0] != 0) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)string);
            GLES20.glBindTexture((int)3553, (int)nArray2[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            bitmap.recycle();
        }
        if (nArray2[0] != 0) {
            new StringBuilder().append("filePath:").append(string).append(", texture = ").append(nArray2[0]);
            return nArray2[0];
        }
        throw new RuntimeException("Error loading texture.");
    }

    public static int createTextureFromAssets(Context context, String string) {
        int n2;
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        if (nArray[0] != 0) {
            context = c.a(context, string);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)context, (int)0);
            context.recycle();
        }
        if ((n2 = nArray[0]) != 0) {
            return n2;
        }
        throw new RuntimeException("Error loading texture.");
    }

    public static int createOESTexture() {
        return OpenGLUtils.createTexture(36197);
    }

    public static void deleteTexture(int n2) {
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = n2;
        GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
    }

    public static void bindTexture(int n2, int n3, int n4) {
        OpenGLUtils.bindTexture(n2, n3, n4, 3553);
    }

    public static void bindTexture(int n2, int n3, int n4, int n5) {
        if (n4 <= 31) {
            GLES20.glActiveTexture((int)(n4 + 33987));
            GLES20.glBindTexture((int)n5, (int)n3);
            GLES20.glUniform1i((int)n2, (int)(n4 + 3));
            return;
        }
        throw new IllegalArgumentException("index must be no more than 31!");
    }

    public static String getErrorString(int n2) {
        switch (n2) {
            default: {
                return OpenGLUtils.getHex(n2);
            }
            case 12302: {
                return "EGL_CONTEXT_LOST";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12288: 
        }
        return "EGL_SUCCESS";
    }

    private static String getHex(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

