/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.filter.glfilter.base;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.GLES30;
import android.text.TextUtils;
import com.meihu.beautylibrary.filter.glfilter.utils.OpenGLUtils;
import com.meihu.beautylibrary.filter.glfilter.utils.TextureRotationUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.LinkedList;

public class h {
    protected static final String VERTEX_SHADER = "attribute vec4 aPosition;                                  \nattribute vec4 aTextureCoord;                              \nvarying vec2 textureCoordinate;                            \nvoid main() {                                              \n    gl_Position = aPosition;                               \n    textureCoordinate = aTextureCoord.xy;                  \n}                                                          \n";
    protected static final String FRAGMENT_SHADER = "precision mediump float;                                   \nvarying vec2 textureCoordinate;                            \nuniform sampler2D inputTexture;                                \nvoid main() {                                              \n    gl_FragColor = texture2D(inputTexture, textureCoordinate); \n}                                                          \n";
    protected String TAG;
    protected Context mContext;
    private final LinkedList<Runnable> mRunOnDraw;
    protected String mVertexShader;
    protected String mFragmentShader;
    protected boolean mIsInitialized;
    protected boolean mFilterEnable;
    protected int mCoordsPerVertex;
    protected int mVertexCount;
    protected int mProgramHandle;
    protected int mPositionHandle;
    protected int mTextureCoordinateHandle;
    protected int mInputTextureHandle;
    protected int mImageWidth;
    protected int mImageHeight;
    protected int mDisplayWidth;
    protected int mDisplayHeight;
    protected int mFrameWidth;
    protected int mFrameHeight;
    protected int[] mFrameBuffers;
    protected int[] mFrameBufferTextures;

    public h(Context context) {
        this(context, VERTEX_SHADER, FRAGMENT_SHADER);
    }

    public h(Context context, String string, String string2) {
        h h2 = this;
        h h3 = this;
        h3.TAG = h3.getClass().getSimpleName();
        h3.mFilterEnable = true;
        h3.mCoordsPerVertex = 2;
        h3.mVertexCount = TextureRotationUtils.CubeVertices.length / 2;
        h3.mFrameWidth = -1;
        h3.mFrameHeight = -1;
        h2.mContext = context;
        h2.mRunOnDraw = new LinkedList();
        this.mVertexShader = string;
        this.mFragmentShader = string2;
        this.initProgramHandle();
    }

    protected static float clamp(float f2, float f3, float f4) {
        if (f2 < f3) {
            return f3;
        }
        if (f2 > f4) {
            return f4;
        }
        return f2;
    }

    public void initProgramHandle() {
        if (!TextUtils.isEmpty((CharSequence)this.mVertexShader) && !TextUtils.isEmpty((CharSequence)this.mFragmentShader)) {
            h h2 = this;
            this.mProgramHandle = OpenGLUtils.createProgram(h2.mVertexShader, this.mFragmentShader);
            h2.mPositionHandle = GLES30.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
            h2.mTextureCoordinateHandle = GLES30.glGetAttribLocation((int)h2.mProgramHandle, (String)"aTextureCoord");
            h2.mInputTextureHandle = GLES30.glGetUniformLocation((int)h2.mProgramHandle, (String)"inputTexture");
            h2.mIsInitialized = true;
        } else {
            h h3 = this;
            h3.mPositionHandle = -1;
            h3.mTextureCoordinateHandle = -1;
            h3.mInputTextureHandle = -1;
            h3.mIsInitialized = false;
        }
    }

    public void onInputSizeChanged(int n2, int n3) {
        h h2 = this;
        h2.mImageWidth = n2;
        h2.mImageHeight = n3;
    }

    public void onDisplaySizeChanged(int n2, int n3) {
        h h2 = this;
        h2.mDisplayWidth = n2;
        h2.mDisplayHeight = n3;
    }

    public boolean drawFrame(int n2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (this.mIsInitialized && n2 != -1 && this.mFilterEnable) {
            int n3 = n2;
            h h2 = this;
            int n4 = h2.mDisplayWidth;
            n2 = h2.mDisplayHeight;
            GLES30.glViewport((int)0, (int)0, (int)n4, (int)n2);
            GLES30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES30.glClear((int)16384);
            GLES30.glUseProgram((int)h2.mProgramHandle);
            h2.runPendingOnDrawTasks();
            this.onDrawTexture(n3, floatBuffer, floatBuffer2);
            return true;
        }
        return false;
    }

    public int drawFrameBuffer(int n2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (n2 != -1 && this.mFrameBuffers != null && this.mIsInitialized && this.mFilterEnable) {
            h h2 = this;
            int n3 = n2;
            h h3 = this;
            int n4 = h3.mFrameWidth;
            n2 = h3.mFrameHeight;
            GLES30.glViewport((int)0, (int)0, (int)n4, (int)n2);
            GLES30.glBindFramebuffer((int)36160, (int)h3.mFrameBuffers[0]);
            GLES30.glUseProgram((int)h3.mProgramHandle);
            h3.runPendingOnDrawTasks();
            h2.onDrawTexture(n3, floatBuffer, floatBuffer2);
            GLES30.glBindFramebuffer((int)36160, (int)0);
            return h2.mFrameBufferTextures[0];
        }
        return n2;
    }

    public int drawFrameBufferClear(int n2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (n2 != -1 && this.mFrameBuffers != null && this.mIsInitialized && this.mFilterEnable) {
            h h2 = this;
            int n3 = n2;
            h h3 = this;
            int n4 = h3.mFrameWidth;
            n2 = h3.mFrameHeight;
            GLES30.glViewport((int)0, (int)0, (int)n4, (int)n2);
            GLES30.glBindFramebuffer((int)36160, (int)h3.mFrameBuffers[0]);
            GLES30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES30.glClear((int)16384);
            GLES30.glUseProgram((int)h3.mProgramHandle);
            h3.runPendingOnDrawTasks();
            h2.onDrawTexture(n3, floatBuffer, floatBuffer2);
            GLES30.glBindFramebuffer((int)36160, (int)0);
            return h2.mFrameBufferTextures[0];
        }
        return n2;
    }

    protected void onDrawTexture(int n2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        h h2 = this;
        h h3 = this;
        floatBuffer.position(0);
        GLES30.glVertexAttribPointer((int)h3.mPositionHandle, (int)this.mCoordsPerVertex, (int)5126, (boolean)false, (int)0, (Buffer)floatBuffer);
        GLES30.glEnableVertexAttribArray((int)h3.mPositionHandle);
        floatBuffer2.position(0);
        GLES30.glVertexAttribPointer((int)h2.mTextureCoordinateHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)floatBuffer2);
        GLES30.glEnableVertexAttribArray((int)h2.mTextureCoordinateHandle);
        GLES30.glActiveTexture((int)33984);
        GLES30.glBindTexture((int)h2.getTextureType(), (int)n2);
        GLES30.glUniform1i((int)h2.mInputTextureHandle, (int)0);
        h2.onDrawFrameBegin();
        h2.onDrawFrame();
        h2.onDrawFrameAfter();
        GLES30.glDisableVertexAttribArray((int)h2.mPositionHandle);
        GLES30.glDisableVertexAttribArray((int)h2.mTextureCoordinateHandle);
        GLES30.glBindTexture((int)h2.getTextureType(), (int)0);
        GLES30.glUseProgram((int)0);
    }

    public void onDrawFrameBegin() {
    }

    protected void onDrawFrame() {
        int n2 = this.mVertexCount;
        GLES30.glDrawArrays((int)5, (int)0, (int)n2);
    }

    public void onDrawFrameAfter() {
    }

    protected void onUnbindTextureValue() {
    }

    public int getTextureType() {
        return 3553;
    }

    public void release() {
        if (this.mIsInitialized) {
            GLES30.glDeleteProgram((int)this.mProgramHandle);
            this.mProgramHandle = -1;
        }
        this.destroyFrameBuffer();
    }

    public void initFrameBuffer(int n2, int n3) {
        if (!((h)object).isInitialized()) {
            return;
        }
        if (((h)object).mFrameBuffers != null && (((h)object).mFrameWidth != n2 || ((h)object).mFrameHeight != n3)) {
            ((h)object).destroyFrameBuffer();
        }
        if (((h)object).mFrameBuffers == null) {
            h h2 = object;
            h2.mFrameWidth = n2;
            h2.mFrameHeight = n3;
            int[] nArray = new int[1];
            h h3 = object;
            h3.mFrameBuffers = nArray;
            int[] nArray2 = new int[1];
            Object object = nArray2;
            h3.mFrameBufferTextures = nArray2;
            OpenGLUtils.createFrameBuffer(nArray, (int[])object, n2, n3);
        }
    }

    public void destroyFrameBuffer() {
        if (!this.mIsInitialized) {
            return;
        }
        int[] nArray = this.mFrameBufferTextures;
        if (this.mFrameBufferTextures != null) {
            GLES30.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mFrameBufferTextures = null;
        }
        nArray = this.mFrameBuffers;
        if (this.mFrameBuffers != null) {
            GLES30.glDeleteFramebuffers((int)1, (int[])nArray, (int)0);
            this.mFrameBuffers = null;
        }
        this.mFrameWidth = -1;
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void setFilterEnable(boolean bl) {
        this.mFilterEnable = bl;
    }

    public int getDisplayWidth() {
        return this.mDisplayWidth;
    }

    public int getDisplayHeight() {
        return this.mDisplayHeight;
    }

    protected void setInteger(final int n2, final int n3) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform1i((int)n2, (int)n3);
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setFloat(final int n2, final float f2) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform1f((int)n2, (float)f2);
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setFloatVec2(final int n2, final float[] fArray) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform2fv((int)n2, (int)1, (FloatBuffer)FloatBuffer.wrap(fArray));
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setFloatVec3(final int n2, final float[] fArray) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform3fv((int)n2, (int)1, (FloatBuffer)FloatBuffer.wrap(fArray));
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setFloatVec4(final int n2, final float[] fArray) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform4fv((int)n2, (int)1, (FloatBuffer)FloatBuffer.wrap(fArray));
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setFloatArray(final int n2, final float[] fArray) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                int n22 = fArray.length;
                GLES30.glUniform1fv((int)n2, (int)n22, (FloatBuffer)FloatBuffer.wrap(fArray));
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setPoint(final int n2, final PointF pointF) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                float[] fArray = new float[2];
                float[] fArray2 = fArray;
                PointF pointF2 = pointF;
                fArray2[0] = pointF2.x;
                fArray[1] = pointF2.y;
                GLES30.glUniform2fv((int)n2, (int)1, (float[])fArray2, (int)0);
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setUniformMatrix3f(final int n2, final float[] fArray) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                Object object = object.fArray;
                GLES30.glUniformMatrix3fv((int)object.n2, (int)1, (boolean)false, (float[])object, (int)0);
            }
        };
        this.runOnDraw(runnable2);
    }

    protected void setUniformMatrix4f(final int n2, final float[] fArray) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                Object object = object.fArray;
                GLES30.glUniformMatrix4fv((int)object.n2, (int)1, (boolean)false, (float[])object, (int)0);
            }
        };
        this.runOnDraw(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.mRunOnDraw;
        synchronized (linkedList) {
            this.mRunOnDraw.addLast(runnable);
            return;
        }
    }

    protected void runPendingOnDrawTasks() {
        while (!this.mRunOnDraw.isEmpty()) {
            this.mRunOnDraw.removeFirst().run();
        }
    }
}

