/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import cn.qqtheme.framework.entity.WheelItem;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WheelView
extends View {
    public static final float LINE_SPACE_MULTIPLIER = 2.0f;
    public static final int TEXT_PADDING = -1;
    public static final int TEXT_SIZE = 16;
    public static final int TEXT_COLOR_FOCUS = -16611122;
    public static final int TEXT_COLOR_NORMAL = -4473925;
    public static final int DIVIDER_COLOR = -8139290;
    public static final int DIVIDER_ALPHA = 220;
    public static final float DIVIDER_THICK = 2.0f;
    public static final int ITEM_OFF_SET = 3;
    private static final float ITEM_PADDING = 13.0f;
    private static final int ACTION_CLICK = 1;
    private static final int ACTION_FLING = 2;
    private static final int ACTION_DRAG = 3;
    private static final int VELOCITY_FLING = 5;
    private static final float SCALE_CONTENT = 0.8f;
    private MessageHandler handler;
    private GestureDetector gestureDetector;
    private OnItemSelectListener onItemSelectListener;
    private OnWheelListener onWheelListener;
    private boolean onlyShowCenterLabel = true;
    private ScheduledFuture<?> mFuture;
    private Paint paintOuterText;
    private Paint paintCenterText;
    private Paint paintIndicator;
    private Paint paintShadow;
    private List<WheelItem> items = new ArrayList<WheelItem>();
    private String label;
    private int maxTextWidth;
    private int maxTextHeight;
    private int textSkewXOffset = 0;
    private int textSize = 16;
    private float itemHeight;
    private Typeface typeface = Typeface.DEFAULT;
    private int textColorOuter = -4473925;
    private int textColorCenter = -16611122;
    private DividerConfig dividerConfig = new DividerConfig();
    private float lineSpaceMultiplier = 2.0f;
    private int textPadding = -1;
    private boolean isLoop = true;
    private float firstLineY;
    private float secondLineY;
    private float totalScrollY = 0.0f;
    private int initPosition = -1;
    private int selectedIndex;
    private int preCurrentIndex;
    private int visibleItemCount = 7;
    private int measuredHeight;
    private int measuredWidth;
    private int radius;
    private int offset = 0;
    private float previousY = 0.0f;
    private long startTime = 0L;
    private int widthMeasureSpec;
    private int gravity = 17;
    private int drawCenterContentStart = 0;
    private int drawOutContentStart = 0;
    private float centerContentOffset;
    private boolean useWeight = false;
    private boolean textSizeAutoFit = true;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        float density = this.getResources().getDisplayMetrics().density;
        if (density < 1.0f) {
            this.centerContentOffset = 2.4f;
        } else if (1.0f <= density && density < 2.0f) {
            this.centerContentOffset = 3.6f;
        } else if (1.0f <= density && density < 2.0f) {
            this.centerContentOffset = 4.5f;
        } else if (2.0f <= density && density < 3.0f) {
            this.centerContentOffset = 6.0f;
        } else if (density >= 3.0f) {
            this.centerContentOffset = density * 2.5f;
        }
        this.judgeLineSpace();
        this.initView(context);
    }

    public final void setVisibleItemCount(int count) {
        if (count % 2 == 0) {
            throw new IllegalArgumentException("must be odd");
        }
        if (count != this.visibleItemCount) {
            this.visibleItemCount = count;
        }
    }

    public final void setCycleDisable(boolean cycleDisable) {
        this.isLoop = !cycleDisable;
    }

    public final void setOffset(@IntRange(from=1L, to=5L) int offset) {
        if (offset < 1 || offset > 5) {
            throw new IllegalArgumentException("must between 1 and 5");
        }
        int count = offset * 2 + 1;
        count = offset % 2 == 0 ? (count += offset) : (count += offset - 1);
        this.setVisibleItemCount(count);
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    public final void setSelectedIndex(int index) {
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        int size = this.items.size();
        if (index == 0 || index > 0 && index < size && index != this.selectedIndex) {
            this.initPosition = index;
            this.totalScrollY = 0.0f;
            this.offset = 0;
            this.invalidate();
        }
    }

    public final void setOnItemSelectListener(OnItemSelectListener onItemSelectListener) {
        this.onItemSelectListener = onItemSelectListener;
    }

    @Deprecated
    public final void setOnWheelListener(OnWheelListener listener) {
        this.onWheelListener = listener;
    }

    public final void setItems(List<?> items) {
        this.items.clear();
        for (Object item : items) {
            if (item instanceof WheelItem) {
                this.items.add((WheelItem)item);
                continue;
            }
            if (item instanceof CharSequence || item instanceof Number) {
                this.items.add(new StringItem(item.toString()));
                continue;
            }
            throw new IllegalArgumentException("please implements " + WheelItem.class.getName());
        }
        this.remeasure();
        this.invalidate();
    }

    public final void setItems(List<?> items, int index) {
        this.setItems(items);
        this.setSelectedIndex(index);
    }

    public final void setItems(String[] list) {
        this.setItems(Arrays.asList(list));
    }

    public final void setItems(List<String> list, String item) {
        int index = list.indexOf(item);
        if (index == -1) {
            index = 0;
        }
        this.setItems(list, index);
    }

    public final void setItems(String[] list, int index) {
        this.setItems(Arrays.asList(list), index);
    }

    public final void setItems(String[] items, String item) {
        this.setItems(Arrays.asList(items), item);
    }

    public final void setLabel(String label, boolean onlyShowCenterLabel) {
        this.label = label;
        this.onlyShowCenterLabel = onlyShowCenterLabel;
    }

    public final void setLabel(String label) {
        this.setLabel(label, true);
    }

    public final void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public void setTextColor(@ColorInt int colorNormal, @ColorInt int colorFocus) {
        this.textColorOuter = colorNormal;
        this.textColorCenter = colorFocus;
        this.paintOuterText.setColor(colorNormal);
        this.paintCenterText.setColor(colorFocus);
    }

    public void setTextColor(@ColorInt int color) {
        this.textColorOuter = color;
        this.textColorCenter = color;
        this.paintOuterText.setColor(color);
        this.paintCenterText.setColor(color);
    }

    public final void setTypeface(Typeface font) {
        this.typeface = font;
        this.paintOuterText.setTypeface(this.typeface);
        this.paintCenterText.setTypeface(this.typeface);
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.textSize = (int)(this.getContext().getResources().getDisplayMetrics().density * size);
            this.paintOuterText.setTextSize((float)this.textSize);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    public void setTextSkewXOffset(int textSkewXOffset) {
        this.textSkewXOffset = textSkewXOffset;
        if (textSkewXOffset != 0) {
            this.paintCenterText.setTextScaleX(1.0f);
        }
    }

    public void setDividerColor(@ColorInt int color) {
        this.dividerConfig.setColor(color);
        this.paintIndicator.setColor(color);
    }

    @Deprecated
    public void setLineConfig(DividerConfig config) {
        this.setDividerConfig(config);
    }

    public void setDividerConfig(DividerConfig config) {
        if (null == config) {
            this.dividerConfig.setVisible(false);
            this.dividerConfig.setShadowVisible(false);
            return;
        }
        this.dividerConfig = config;
        this.paintIndicator.setColor(config.color);
        this.paintIndicator.setStrokeWidth(config.thick);
        this.paintIndicator.setAlpha(config.alpha);
        this.paintShadow.setColor(config.shadowColor);
        this.paintShadow.setAlpha(config.shadowAlpha);
    }

    public final void setLineSpaceMultiplier(@FloatRange(from=2.0, to=4.0) float multiplier) {
        this.lineSpaceMultiplier = multiplier;
        this.judgeLineSpace();
    }

    @Deprecated
    public void setPadding(int padding) {
        this.setTextPadding(padding);
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = ConvertUtils.toPx(this.getContext(), textPadding);
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    public void setTextSizeAutoFit(boolean textSizeAutoFit) {
        this.textSizeAutoFit = textSizeAutoFit;
    }

    private void judgeLineSpace() {
        if (this.lineSpaceMultiplier < 1.5f) {
            this.lineSpaceMultiplier = 1.5f;
        } else if (this.lineSpaceMultiplier > 4.0f) {
            this.lineSpaceMultiplier = 4.0f;
        }
    }

    private void initView(Context context) {
        this.handler = new MessageHandler(this);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public final boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                WheelView.this.scrollBy(velocityY);
                return true;
            }
        });
        this.gestureDetector.setIsLongpressEnabled(false);
        this.initPaints();
        this.initDataForIDE();
    }

    private void initPaints() {
        this.paintOuterText = new Paint();
        this.paintOuterText.setAntiAlias(true);
        this.paintOuterText.setColor(this.textColorOuter);
        this.paintOuterText.setTypeface(this.typeface);
        this.paintOuterText.setTextSize((float)this.textSize);
        this.paintCenterText = new Paint();
        this.paintCenterText.setAntiAlias(true);
        this.paintCenterText.setColor(this.textColorCenter);
        this.paintCenterText.setTextScaleX(1.0f);
        this.paintCenterText.setTypeface(this.typeface);
        this.paintCenterText.setTextSize((float)this.textSize);
        this.paintIndicator = new Paint();
        this.paintIndicator.setAntiAlias(true);
        this.paintIndicator.setColor(this.dividerConfig.color);
        this.paintIndicator.setStrokeWidth(this.dividerConfig.thick);
        this.paintIndicator.setAlpha(this.dividerConfig.alpha);
        this.paintShadow = new Paint();
        this.paintShadow.setAntiAlias(true);
        this.paintShadow.setColor(this.dividerConfig.shadowColor);
        this.paintShadow.setAlpha(this.dividerConfig.shadowAlpha);
        this.setLayerType(1, null);
    }

    private void initDataForIDE() {
        if (this.isInEditMode()) {
            this.setItems(new String[]{"\u674e\u7389\u6c5f", "\u7537", "\u8d35\u5dde", "\u7a7f\u9752\u4eba"});
        }
    }

    private void remeasure() {
        if (this.items == null) {
            return;
        }
        this.measureTextWidthHeight();
        int halfCircumference = (int)(this.itemHeight * (float)(this.visibleItemCount - 1));
        this.measuredHeight = (int)((double)(halfCircumference * 2) / Math.PI);
        this.radius = (int)((double)halfCircumference / Math.PI);
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (this.useWeight) {
            this.measuredWidth = View.MeasureSpec.getSize((int)this.widthMeasureSpec);
        } else if (params != null && params.width > 0) {
            this.measuredWidth = params.width;
        } else {
            this.measuredWidth = this.maxTextWidth;
            if (this.textPadding < 0) {
                this.textPadding = ConvertUtils.toPx(this.getContext(), 13.0f);
            }
            this.measuredWidth += this.textPadding * 2;
            if (!TextUtils.isEmpty((CharSequence)this.label)) {
                this.measuredWidth += this.obtainTextWidth(this.paintCenterText, this.label);
            }
        }
        LogUtils.debug("measuredWidth=" + this.measuredWidth + ",measuredHeight=" + this.measuredHeight);
        this.firstLineY = ((float)this.measuredHeight - this.itemHeight) / 2.0f;
        this.secondLineY = ((float)this.measuredHeight + this.itemHeight) / 2.0f;
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.items.size() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.items.size(); ++i) {
            String s1 = this.obtainContentText(this.items.get(i));
            this.paintCenterText.getTextBounds(s1, 0, s1.length(), rect);
            int textWidth = rect.width();
            if (textWidth > this.maxTextWidth) {
                this.maxTextWidth = textWidth;
            }
            this.paintCenterText.getTextBounds("\u6d4b\u8bd5", 0, 2, rect);
            this.maxTextHeight = rect.height() + 2;
        }
        this.itemHeight = this.lineSpaceMultiplier * (float)this.maxTextHeight;
    }

    private void smoothScroll(int actionType) {
        this.cancelFuture();
        if (actionType == 2 || actionType == 3) {
            this.offset = (int)((this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight);
            this.offset = (float)this.offset > this.itemHeight / 2.0f ? (int)(this.itemHeight - (float)this.offset) : -this.offset;
        }
        SmoothScrollTimerTask command = new SmoothScrollTimerTask(this, this.offset);
        this.mFuture = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(command, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void scrollBy(float velocityY) {
        this.cancelFuture();
        InertiaTimerTask command = new InertiaTimerTask(this, velocityY);
        this.mFuture = Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(command, 0L, 5L, TimeUnit.MILLISECONDS);
    }

    private void cancelFuture() {
        if (this.mFuture != null && !this.mFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    private void itemSelectedCallback() {
        if (this.onItemSelectListener == null && this.onWheelListener == null) {
            return;
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WheelView.this.onItemSelectListener != null) {
                    WheelView.this.onItemSelectListener.onSelected(WheelView.this.selectedIndex);
                }
                if (WheelView.this.onWheelListener != null) {
                    WheelView.this.onWheelListener.onSelected(true, WheelView.this.selectedIndex, ((WheelItem)WheelView.this.items.get(WheelView.this.selectedIndex)).getName());
                }
            }
        }, 200L);
    }

    protected void onDraw(Canvas canvas) {
        int counter;
        if (this.items == null || this.items.size() == 0) {
            return;
        }
        String[] visibleItemStrings = new String[this.visibleItemCount];
        int change = (int)(this.totalScrollY / this.itemHeight);
        this.preCurrentIndex = this.initPosition + change % this.items.size();
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.items.size() - 1) {
                this.preCurrentIndex = this.items.size() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.items.size() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.items.size() - 1) {
                this.preCurrentIndex -= this.items.size();
            }
        }
        float itemHeightOffset = this.totalScrollY % this.itemHeight;
        for (counter = 0; counter < this.visibleItemCount; ++counter) {
            int index = this.preCurrentIndex - (this.visibleItemCount / 2 - counter);
            if (this.isLoop) {
                index = this.getLoopMappingIndex(index);
                visibleItemStrings[counter] = this.items.get(index).getName();
                continue;
            }
            visibleItemStrings[counter] = index < 0 ? "" : (index > this.items.size() - 1 ? "" : this.items.get(index).getName());
        }
        if (this.dividerConfig.visible) {
            float ratio = this.dividerConfig.ratio;
            canvas.drawLine((float)this.measuredWidth * ratio, this.firstLineY, (float)this.measuredWidth * (1.0f - ratio), this.firstLineY, this.paintIndicator);
            canvas.drawLine((float)this.measuredWidth * ratio, this.secondLineY, (float)this.measuredWidth * (1.0f - ratio), this.secondLineY, this.paintIndicator);
        }
        if (this.dividerConfig.shadowVisible) {
            this.paintShadow.setColor(this.dividerConfig.shadowColor);
            this.paintShadow.setAlpha(this.dividerConfig.shadowAlpha);
            canvas.drawRect(0.0f, this.firstLineY, (float)this.measuredWidth, this.secondLineY, this.paintShadow);
        }
        for (counter = 0; counter < this.visibleItemCount; ++counter) {
            canvas.save();
            double radian = (this.itemHeight * (float)counter - itemHeightOffset) / (float)this.radius;
            float angle = (float)(90.0 - radian / Math.PI * 180.0);
            if (angle >= 90.0f || angle <= -90.0f) {
                canvas.restore();
                continue;
            }
            String tempStr = this.obtainContentText(visibleItemStrings[counter]);
            String contentText = !this.onlyShowCenterLabel && !TextUtils.isEmpty((CharSequence)this.label) && !TextUtils.isEmpty((CharSequence)tempStr) ? tempStr + this.label : tempStr;
            if (this.textSizeAutoFit) {
                this.remeasureTextSize(contentText);
                this.gravity = 17;
            } else {
                this.gravity = 0x800003;
            }
            this.measuredCenterContentStart(contentText);
            this.measuredOutContentStart(contentText);
            float translateY = (float)((double)this.radius - Math.cos(radian) * (double)this.radius - Math.sin(radian) * (double)this.maxTextHeight / 2.0);
            canvas.translate(0.0f, translateY);
            if (translateY <= this.firstLineY && (float)this.maxTextHeight + translateY >= this.firstLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.firstLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.firstLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.centerContentOffset, this.paintCenterText);
                canvas.restore();
            } else if (translateY <= this.secondLineY && (float)this.maxTextHeight + translateY >= this.secondLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.secondLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.centerContentOffset, this.paintCenterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.secondLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
            } else if (translateY >= this.firstLineY && (float)this.maxTextHeight + translateY <= this.secondLineY) {
                canvas.clipRect(0, 0, this.measuredWidth, this.maxTextHeight);
                float y = (float)this.maxTextHeight - this.centerContentOffset;
                int i = 0;
                for (WheelItem item : this.items) {
                    if (item.getName().equals(tempStr)) {
                        this.selectedIndex = i;
                        break;
                    }
                    ++i;
                }
                if (this.onlyShowCenterLabel && !TextUtils.isEmpty((CharSequence)this.label)) {
                    contentText = contentText + this.label;
                }
                canvas.drawText(contentText, (float)this.drawCenterContentStart, y, this.paintCenterText);
            } else {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.itemHeight);
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                float offsetCoefficient = (float)Math.pow(Math.abs(angle) / 90.0f, 2.2);
                if (this.textSkewXOffset != 0) {
                    this.paintOuterText.setTextSkewX((float)((this.textSkewXOffset > 0 ? 1 : -1) * (angle > 0.0f ? -1 : 1)) * 0.5f * offsetCoefficient);
                    this.paintOuterText.setAlpha((int)((1.0f - offsetCoefficient) * 255.0f));
                }
                canvas.drawText(contentText, (float)this.drawOutContentStart + (float)this.textSkewXOffset * offsetCoefficient, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
            }
            canvas.restore();
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    private void remeasureTextSize(String contentText) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
        int width = rect.width();
        int size = this.textSize;
        while (width > this.measuredWidth) {
            this.paintCenterText.setTextSize((float)(--size));
            this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
            width = rect.width();
        }
        this.paintOuterText.setTextSize((float)size);
    }

    private int getLoopMappingIndex(int index) {
        if (index < 0) {
            index += this.items.size();
            index = this.getLoopMappingIndex(index);
        } else if (index > this.items.size() - 1) {
            index -= this.items.size();
            index = this.getLoopMappingIndex(index);
        }
        return index;
    }

    private String obtainContentText(Object item) {
        if (item == null) {
            return "";
        }
        if (item instanceof WheelItem) {
            return ((WheelItem)item).getName();
        }
        if (item instanceof Integer) {
            return String.format(Locale.getDefault(), "%02d", (int)((Integer)item));
        }
        return item.toString();
    }

    private void measuredCenterContentStart(String content) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.gravity) {
            case 17: {
                this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                break;
            }
            case 3: {
                this.drawCenterContentStart = ConvertUtils.toPx(this.getContext(), 8.0f);
                break;
            }
            case 5: {
                this.drawCenterContentStart = this.measuredWidth - rect.width() - (int)this.centerContentOffset;
            }
        }
    }

    private void measuredOutContentStart(String content) {
        Rect rect = new Rect();
        this.paintOuterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.gravity) {
            case 17: {
                this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                break;
            }
            case 3: {
                this.drawOutContentStart = ConvertUtils.toPx(this.getContext(), 8.0f);
                break;
            }
            case 5: {
                this.drawOutContentStart = this.measuredWidth - rect.width() - (int)this.centerContentOffset;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.widthMeasureSpec = widthMeasureSpec;
        this.remeasure();
        this.setMeasuredDimension(this.measuredWidth, this.measuredHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean eventConsumed = this.gestureDetector.onTouchEvent(event);
        ViewParent parent = this.getParent();
        switch (event.getAction()) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.cancelFuture();
                this.previousY = event.getRawY();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float dy = this.previousY - event.getRawY();
                this.previousY = event.getRawY();
                this.totalScrollY += dy;
                if (this.isLoop) break;
                float top = (float)(-this.initPosition) * this.itemHeight;
                float bottom = (float)(this.items.size() - 1 - this.initPosition) * this.itemHeight;
                if ((double)this.totalScrollY - (double)this.itemHeight * 0.25 < (double)top) {
                    top = this.totalScrollY - dy;
                } else if ((double)this.totalScrollY + (double)this.itemHeight * 0.25 > (double)bottom) {
                    bottom = this.totalScrollY - dy;
                }
                if (this.totalScrollY < top) {
                    this.totalScrollY = (int)top;
                    break;
                }
                if (!(this.totalScrollY > bottom)) break;
                this.totalScrollY = (int)bottom;
                break;
            }
            default: {
                if (!eventConsumed) {
                    float y = event.getY();
                    double L = Math.acos(((float)this.radius - y) / (float)this.radius) * (double)this.radius;
                    int circlePosition = (int)((L + (double)(this.itemHeight / 2.0f)) / (double)this.itemHeight);
                    float extraOffset = (this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight;
                    this.offset = (int)((float)(circlePosition - this.visibleItemCount / 2) * this.itemHeight - extraOffset);
                    if (System.currentTimeMillis() - this.startTime > 120L) {
                        this.smoothScroll(3);
                    } else {
                        this.smoothScroll(1);
                    }
                }
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(false);
            }
        }
        if (event.getAction() != 0) {
            this.invalidate();
        }
        return true;
    }

    protected int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    private int obtainTextWidth(Paint paint, String str) {
        int iRet = 0;
        if (str != null && str.length() > 0) {
            int len = str.length();
            float[] widths = new float[len];
            paint.getTextWidths(str, widths);
            for (int j = 0; j < len; ++j) {
                iRet += (int)Math.ceil(widths[j]);
            }
        }
        return iRet;
    }

    private static class InertiaTimerTask
    extends TimerTask {
        float a = 2.1474836E9f;
        final float velocityY;
        final WheelView view;

        InertiaTimerTask(WheelView view, float velocityY) {
            this.view = view;
            this.velocityY = velocityY;
        }

        @Override
        public final void run() {
            if (this.a == 2.1474836E9f) {
                this.a = Math.abs(this.velocityY) > 2000.0f ? (this.velocityY > 0.0f ? 2000.0f : -2000.0f) : this.velocityY;
            }
            if (Math.abs(this.a) >= 0.0f && Math.abs(this.a) <= 20.0f) {
                this.view.cancelFuture();
                this.view.handler.sendEmptyMessage(2000);
                return;
            }
            int i = (int)(this.a * 10.0f / 1000.0f);
            this.view.totalScrollY = this.view.totalScrollY - (float)i;
            if (!this.view.isLoop) {
                float itemHeight = this.view.itemHeight;
                float top = (float)(-this.view.initPosition) * itemHeight;
                float bottom = (float)(this.view.getItemCount() - 1 - this.view.initPosition) * itemHeight;
                if ((double)this.view.totalScrollY - (double)itemHeight * 0.25 < (double)top) {
                    top = this.view.totalScrollY + (float)i;
                } else if ((double)this.view.totalScrollY + (double)itemHeight * 0.25 > (double)bottom) {
                    bottom = this.view.totalScrollY + (float)i;
                }
                if (this.view.totalScrollY <= top) {
                    this.a = 40.0f;
                    this.view.totalScrollY = (int)top;
                } else if (this.view.totalScrollY >= bottom) {
                    this.view.totalScrollY = (int)bottom;
                    this.a = -40.0f;
                }
            }
            this.a = this.a < 0.0f ? (this.a += 20.0f) : (this.a -= 20.0f);
            this.view.handler.sendEmptyMessage(1000);
        }
    }

    private static class SmoothScrollTimerTask
    extends TimerTask {
        int realTotalOffset = Integer.MAX_VALUE;
        int realOffset = 0;
        int offset;
        final WheelView view;

        SmoothScrollTimerTask(WheelView view, int offset) {
            this.view = view;
            this.offset = offset;
        }

        @Override
        public void run() {
            if (this.realTotalOffset == Integer.MAX_VALUE) {
                this.realTotalOffset = this.offset;
            }
            this.realOffset = (int)((float)this.realTotalOffset * 0.1f);
            if (this.realOffset == 0) {
                this.realOffset = this.realTotalOffset < 0 ? -1 : 1;
            }
            if (Math.abs(this.realTotalOffset) <= 1) {
                this.view.cancelFuture();
                this.view.handler.sendEmptyMessage(3000);
            } else {
                this.view.totalScrollY = this.view.totalScrollY + (float)this.realOffset;
                if (!this.view.isLoop) {
                    float itemHeight = this.view.itemHeight;
                    float top = (float)(-this.view.initPosition) * itemHeight;
                    float bottom = (float)(this.view.getItemCount() - 1 - this.view.initPosition) * itemHeight;
                    if (this.view.totalScrollY <= top || this.view.totalScrollY >= bottom) {
                        this.view.totalScrollY = this.view.totalScrollY - (float)this.realOffset;
                        this.view.cancelFuture();
                        this.view.handler.sendEmptyMessage(3000);
                        return;
                    }
                }
                this.view.handler.sendEmptyMessage(1000);
                this.realTotalOffset -= this.realOffset;
            }
        }
    }

    private static class MessageHandler
    extends Handler {
        static final int WHAT_INVALIDATE = 1000;
        static final int WHAT_SMOOTH_SCROLL = 2000;
        static final int WHAT_ITEM_SELECTED = 3000;
        final WheelView view;

        MessageHandler(WheelView view) {
            this.view = view;
        }

        public final void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    this.view.invalidate();
                    break;
                }
                case 2000: {
                    this.view.smoothScroll(2);
                    break;
                }
                case 3000: {
                    this.view.itemSelectedCallback();
                }
            }
        }
    }

    @Deprecated
    public static interface OnWheelViewListener
    extends OnWheelListener {
    }

    @Deprecated
    public static interface OnWheelListener {
        public void onSelected(boolean var1, int var2, String var3);
    }

    public static interface OnItemSelectListener {
        public void onSelected(int var1);
    }

    private static class StringItem
    implements WheelItem {
        private String name;

        private StringItem(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    @Deprecated
    public static class LineConfig
    extends DividerConfig {
    }

    public static class DividerConfig {
        public static final float FILL = 0.0f;
        public static final float WRAP = 1.0f;
        protected boolean visible = true;
        protected boolean shadowVisible = false;
        protected int color = -8139290;
        protected int shadowColor = -4473925;
        protected int shadowAlpha = 100;
        protected int alpha = 220;
        protected float ratio = 0.1f;
        protected float thick = 2.0f;

        public DividerConfig() {
        }

        public DividerConfig(@FloatRange(from=0.0, to=1.0) float ratio) {
            this.ratio = ratio;
        }

        public DividerConfig setVisible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public DividerConfig setShadowVisible(boolean shadowVisible) {
            this.shadowVisible = shadowVisible;
            if (shadowVisible && this.color == -8139290) {
                this.color = this.shadowColor;
                this.alpha = 255;
            }
            return this;
        }

        public DividerConfig setShadowColor(@ColorInt int color) {
            this.shadowVisible = true;
            this.shadowColor = color;
            return this;
        }

        public DividerConfig setShadowAlpha(@IntRange(from=1L, to=255L) int alpha) {
            this.shadowAlpha = alpha;
            return this;
        }

        public DividerConfig setColor(@ColorInt int color) {
            this.color = color;
            return this;
        }

        public DividerConfig setAlpha(@IntRange(from=1L, to=255L) int alpha) {
            this.alpha = alpha;
            return this;
        }

        public DividerConfig setRatio(@FloatRange(from=0.0, to=1.0) float ratio) {
            this.ratio = ratio;
            return this;
        }

        public DividerConfig setThick(float thick) {
            this.thick = thick;
            return this;
        }

        public String toString() {
            return "visible=" + this.visible + ",color=" + this.color + ",alpha=" + this.alpha + ",thick=" + this.thick;
        }
    }
}

