/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.content.Context;
import com.baidu.speech.core.BDSSDKLoader;
import com.baidu.speech.utils.AsrError;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.Policy;
import com.baidu.speech.utils.Utility;
import com.baidu.speech.utils.auth.GetTtsLicenseWork;
import com.baidu.speech.utils.auth.IMResult;
import com.baidu.speech.utils.auth.IMemorizable;
import com.baidu.speech.utils.auth.SharedPreferencesUtils;
import com.baidu.speech.utils.auth.StringTool;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineAuth
implements IMemorizable<OfflineAuth, OfflineResult> {
    private String mAppCode;
    private String mLicenseFilePath;
    private String mAuthSN;
    private final int downloadLicenseFailureInvalidSN = 100017;
    private final int offlineEngineDownloadLicenseFailure = 100019;
    private static final String TAG = "OfflineAuth";
    private Context context;

    public void setContext(Context context) {
        this.context = context;
    }

    public String getAppCode() {
        return this.mAppCode;
    }

    public void setAppCode(String string) {
        this.mAppCode = string;
    }

    public String getLicenseFilePath() {
        return this.mLicenseFilePath;
    }

    public void setAuthSN(String string) {
        this.mAuthSN = string;
    }

    public String getAuthSN() {
        return this.mAuthSN;
    }

    public void setLicenseFilePath(String string) {
        this.mLicenseFilePath = string;
    }

    @Override
    public int compareTo(OfflineAuth offlineAuth) {
        String string = offlineAuth.getAppCode();
        String string2 = offlineAuth.getLicenseFilePath();
        boolean bl = StringTool.isEqual(this.mAppCode, string);
        boolean bl2 = StringTool.isEqual(this.mLicenseFilePath, string2);
        return bl && bl2 ? 0 : 1;
    }

    @Override
    public OfflineResult call() throws Exception {
        OfflineResult offlineResult = new OfflineResult();
        offlineResult.setContext(this.context);
        offlineResult.setLicenseFilePath(this.mLicenseFilePath);
        offlineResult.setAppId(this.mAppCode);
        offlineResult.setAuthSN(this.mAuthSN);
        boolean bl = offlineResult.isValid();
        if (!bl) {
            int n = -1;
            long l = SharedPreferencesUtils.getLong(this.context, "getLicense_expires", 0L);
            long l2 = SharedPreferencesUtils.getLong(this.context, "getLicense_time", 0L);
            int n2 = SharedPreferencesUtils.getInt(this.context, "getLicense_err_no", -1);
            String string = SharedPreferencesUtils.getString(this.context, "SN", "");
            long l3 = System.currentTimeMillis() - l2;
            if (string.equals(this.mAuthSN) && (n2 == -1006 || n2 == -1007 || n2 == -1008 || n2 == -1011) && l3 <= 86400000L) {
                offlineResult.setError(100017);
                return offlineResult;
            }
            if (l3 > l) {
                try {
                    FutureTask<Integer> futureTask = new FutureTask<Integer>(new GetTtsLicenseWork(this.context, this.mAppCode, this.mLicenseFilePath, this.mAuthSN));
                    Thread thread = new Thread(futureTask);
                    thread.start();
                    n = futureTask.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    LogUtil.d(TAG, interruptedException.toString());
                }
                catch (ExecutionException executionException) {
                    LogUtil.d(TAG, executionException.getCause().toString());
                }
                catch (TimeoutException timeoutException) {
                    LogUtil.d(TAG, timeoutException.toString());
                }
            }
            LogUtil.d(TAG, "- downloadLicense ret = " + n);
            offlineResult.setDownloadLicenseResult(n);
            if (n < 0) {
                offlineResult.setError(100019);
            } else {
                offlineResult.isValid();
            }
        }
        return offlineResult;
    }

    public static class OfflineResult
    implements IMResult {
        private int mVerifyResult = -1;
        private int mDownloadLicenseResult = -1;
        private String mLicenseFilePath;
        private String mAppId;
        private int mError;
        private String mAuthSN;
        private Context context;
        private static final int PACKAGE_NAME_UNMATCH = -2;
        private static final int SIGN_OR_CODE_UNMATCH = -3;
        private static final int CUID_UNMATCH = -4;
        private static final int OFFICIAL_LICENSE_EXPIRED = -5;
        private static final int WILL_EXPIRED_AFTER_A_MONTH = -6;
        private static final int PLATFORM_UNMATCH = -7;
        private static final int INVALID_LICENSE = -8;
        private static final int TEMP_LICENSE_EXPIRED = -10;
        private static final int CODE_VERIFY_OK_MIN = 0;
        private static final int CODE_TEMP_LICENSE_MIN = 10000;

        public void setContext(Context context) {
            this.context = context;
        }

        public int getVerifyResult() {
            return this.mVerifyResult;
        }

        public void setVerifyResult(int n) {
            this.mVerifyResult = n;
        }

        public int getLeftValidDays() {
            return this.mVerifyResult >= 10000 ? this.mVerifyResult - 10000 : 0;
        }

        public int getDownloadLicenseResult() {
            return this.mDownloadLicenseResult;
        }

        public void setDownloadLicenseResult(int n) {
            this.mDownloadLicenseResult = n;
        }

        public String getLicenseFilePath() {
            return this.mLicenseFilePath;
        }

        public void setLicenseFilePath(String string) {
            this.mLicenseFilePath = string;
        }

        public String getAppId() {
            return this.mAppId;
        }

        public void setAppId(String string) {
            this.mAppId = string;
        }

        public void setAuthSN(String string) {
            this.mAuthSN = string;
        }

        public String getAuthSN() {
            return this.mAuthSN;
        }

        public int getError() {
            return this.mError;
        }

        public void setError(int n) {
            LogUtil.d(OfflineAuth.TAG, "this=" + this + "--error=" + AsrError.getDescFromCode(this.mError));
            this.mError = n;
        }

        public String getNotifyMessage() {
            if (this.isValidOfficial()) {
                return "valid official";
            }
            if (this.isValidTemp()) {
                return "valid temp";
            }
            switch (this.mVerifyResult) {
                case -2: {
                    return "package name unmatched";
                }
                case -3: {
                    return "sign or appcode unmatched";
                }
                case -4: {
                    return "cuid unmatched";
                }
                case -5: {
                    return "official license expired";
                }
                case -6: {
                    return "will expire after a month";
                }
                case -7: {
                    return "platform unmatched";
                }
                case -8: {
                    return "license not exist or invalid license";
                }
                case -10: {
                    return "temp license expired";
                }
            }
            return "not a valid result";
        }

        public boolean isValidTemp() {
            return this.mVerifyResult >= 10000;
        }

        public boolean isValidOfficial() {
            return this.mVerifyResult >= 0 && this.mVerifyResult < 10000;
        }

        public boolean isOfficialExpired() {
            return this.mVerifyResult == -5 || this.mVerifyResult == -6;
        }

        public boolean isValid() {
            LogUtil.d(OfflineAuth.TAG, "isValid begin");
            if (StringTool.isEmpty(this.mLicenseFilePath)) {
                return false;
            }
            File file = new File(this.mLicenseFilePath);
            if (file.exists()) {
                String string;
                String string2 = Policy.uid(this.context);
                String string3 = Utility.getPackageName(this.context);
                byte[] byArray = new byte[128];
                LogUtil.d(OfflineAuth.TAG, "verify license before ");
                this.mVerifyResult = BDSSDKLoader.bdVerifyLicense(this.context, this.mAppId, string2, this.mAuthSN, string3, this.mLicenseFilePath, byArray);
                LogUtil.d(OfflineAuth.TAG, "verify result=" + this.mVerifyResult);
                if (byArray != null) {
                    string = new String(byArray);
                    LogUtil.d(OfflineAuth.TAG, "get appIdStr=" + string);
                }
                if (this.mVerifyResult < 0) {
                    return false;
                }
                try {
                    string = this.mAppId;
                }
                catch (Exception exception) {
                    LogUtil.d(OfflineAuth.TAG, "embedded statistics start exception=" + exception.toString());
                }
                return true;
            }
            return false;
        }
    }
}

