/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtility {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";

    public static String generateSerialNumber() {
        String string = UUID.randomUUID().toString();
        return string;
    }

    public static byte[] shortArrayToByteArray(short[] sArray) {
        int n = sArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2);
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < n; ++i) {
            byteBuffer.putShort(i * 2, sArray[i]);
        }
        return byteBuffer.array();
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        try {
            int[] nArray = CommonUtility.computeFailure(byArray2);
            int n2 = 0;
            if (byArray.length == 0) {
                return -1;
            }
            if (n >= byArray.length) {
                return -1;
            }
            for (int i = n; i < byArray.length; ++i) {
                while (n2 > 0 && byArray2[n2] != byArray[i]) {
                    n2 = nArray[n2 - 1];
                }
                if (byArray2[n2] == byArray[i]) {
                    ++n2;
                }
                if (n2 != byArray2.length) continue;
                return i - byArray2.length + 1;
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int[] computeFailure(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            while (n > 0 && byArray[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray[n] == byArray[i]) {
                // empty if block
            }
            nArray[i] = ++n;
        }
        return nArray;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = CommonUtility.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isWifiConnected(Context context) {
        NetworkInfo networkInfo = CommonUtility.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static byte[] copyBytesOfRange(byte[] byArray, int n, int n2) {
        if (n > n2 || n < 0 || n2 < 0 || n2 > byArray.length) {
            return null;
        }
        byte[] byArray2 = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            byArray2[i - n] = byArray[i];
        }
        return byArray2;
    }

    public static byte[] addCAFHeaderForPCMData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        long l = byArray.length;
        long l2 = l + 44L;
        long l3 = 16000L;
        int n = 1;
        long l4 = 16L * l2 * (long)n / 8L;
        byte[] byArray2 = new byte[]{82, 73, 70, 70, (byte)(l2 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)n, 0, (byte)(l3 & 0xFFL), (byte)(l3 >> 8 & 0xFFL), (byte)(l3 >> 16 & 0xFFL), (byte)(l3 >> 24 & 0xFFL), (byte)(l4 & 0xFFL), (byte)(l4 >> 8 & 0xFFL), (byte)(l4 >> 16 & 0xFFL), (byte)(l4 >> 24 & 0xFFL), 2, 0, 16, 0, 100, 97, 116, 97, (byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    public static String parseByte2HexStr(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                string = '0' + string;
            }
            stringBuilder.append(string.toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static byte[] parseHexStr2Byte(String string) {
        if (string.length() < 1) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            int n = Integer.parseInt(string.substring(i * 2, i * 2 + 1), 16);
            int n2 = Integer.parseInt(string.substring(i * 2 + 1, i * 2 + 2), 16);
            byArray[i] = (byte)(n * 16 + n2);
        }
        return byArray;
    }

    public static String AES_cbc_encrypt(String string, String string2, String string3) {
        try {
            Cipher.getMaxAllowedKeyLength(ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes("utf-8"), "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(string3.getBytes("utf-8")));
            byte[] byArray = cipher.doFinal(string.getBytes("utf-8"));
            return CommonUtility.parseByte2HexStr(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] AES_cbc_decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            Cipher.getMaxAllowedKeyLength(ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray3));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
    }

    public static String urlEncoded(HashMap<String, String> hashMap) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string);
            if (string2 == null) {
                string2 = "";
            }
            if (n == 0) {
                stringBuilder.append(String.format("%s=%s", string, URLEncoder.encode(string2, "utf-8")));
            } else {
                stringBuilder.append(String.format("&%s=%s", string, URLEncoder.encode(string2, "utf-8")));
            }
            ++n;
        }
        String string = stringBuilder.toString();
        return string;
    }

    public static void asserts(boolean bl, String string) {
        if (!bl) {
            throw new AssertionError((Object)string);
        }
    }

    public static boolean ping6(String string) {
        try {
            String string2 = "ping6 -c 1 -W 1 " + string;
            Process process = Runtime.getRuntime().exec(string2);
            Process process2 = Runtime.getRuntime().exec(string2);
            Process process3 = Runtime.getRuntime().exec(string2);
            int n = process.waitFor();
            int n2 = process2.waitFor();
            int n3 = process3.waitFor();
            return n == 0 || n2 == 0 || n3 == 0;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }
}

