/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.speech.RecognitionService;
import android.util.AndroidRuntimeException;
import com.baidu.speech.EventListener;
import com.baidu.speech.EventManager;
import com.baidu.speech.EventManagerFactory;
import com.baidu.speech.asr.SpeechConstant;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class VoiceRecognitionService
extends RecognitionService {
    public static final String TAG = "VoiceRecognitionService";
    public static final String VERSION_NAME = "3.4.4.106";
    public static final int EVENT_ENGINE_SWITCH = 12;
    private static final Logger logger = Logger.getLogger("VoiceRecognitionService");
    private static final int EVENT_ERROR = 11;
    private static final int EVENT_THIRD_DATA = 12;
    private boolean internal;
    private EventManager mEventManagerAsr;
    private MyListener mUsingListener;
    private Bundle mFinalBundle;
    private boolean mLongSpeech;

    public static String getSdkVersion() {
        return VERSION_NAME;
    }

    public static Bundle fromJson(JSONObject jSONObject) {
        Bundle bundle = new Bundle();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            int n;
            Object object;
            String string = (String)iterator.next();
            JSONArray jSONArray = jSONObject.optJSONArray(string);
            String string2 = jSONObject.optString(string);
            if (jSONArray != null && jSONArray.length() <= 0) {
                bundle.putStringArray(string, new String[0]);
                continue;
            }
            if (jSONArray != null && jSONArray.optString(0) != null) {
                object = new ArrayList();
                for (n = 0; n < jSONArray.length(); ++n) {
                    ((ArrayList)object).add(jSONArray.optString(n));
                }
                bundle.putStringArrayList(string, (ArrayList)object);
                continue;
            }
            if (jSONArray != null && !Double.isNaN(jSONArray.optDouble(0))) {
                object = new double[jSONArray.length()];
                for (n = 0; n < jSONArray.length(); ++n) {
                    object[n] = jSONArray.optDouble(n);
                }
                bundle.putDoubleArray(string, (double[])object);
                continue;
            }
            if (string2 == null) continue;
            bundle.putString(string, string2);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate() {
        super.onCreate();
        ServiceInfo serviceInfo = VoiceRecognitionService.class;
        synchronized (VoiceRecognitionService.class) {
            if (null == this.mEventManagerAsr) {
                this.mEventManagerAsr = EventManagerFactory.create(this.getApplicationContext(), "asr");
                this.mUsingListener = new MyListener();
                this.mEventManagerAsr.registerListener(this.mUsingListener);
                SpeechConstant.PUBLIC_DECODER = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            logger.info(String.format("onCreate(), hashcode=%s", ((Object)((Object)this)).hashCode()));
            try {
                Class.forName("com.baidu.android.voicedemo.SettingMore");
                this.internal = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info("internal=" + this.internal);
            try {
                serviceInfo = this.getPackageManager().getServiceInfo(new ComponentName(this.getPackageName(), ((Object)((Object)this)).getClass().getName()), 128);
                boolean bl = serviceInfo.exported;
                if (bl) {
                    throw new AndroidRuntimeException(((Object)((Object)this)).getClass().getName() + ", 'android:exported' should be false, please modify AndroidManifest.xml");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            return;
        }
    }

    private JSONObject convertIntentToJson(Intent intent) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        intent.getStringExtra("a");
        Bundle bundle = intent.getExtras();
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (string.equals("args") && object instanceof String) {
                String[] stringArray;
                String string2 = (String)object;
                for (String string3 : stringArray = string2.split("--")) {
                    int n = string3.trim().indexOf(" ");
                    if (n < 0) {
                        n = string3.indexOf("\t");
                    }
                    if (n < 0) {
                        n = string3.indexOf("=");
                    }
                    if (n <= 0) continue;
                    String string4 = string3.substring(0, n).trim();
                    String string5 = string3.substring(n + 1).trim();
                    hashMap.put(string4, string5);
                }
                continue;
            }
            hashMap.put(string, object);
        }
        return new JSONObject(hashMap);
    }

    protected void onStartListening(Intent intent, RecognitionService.Callback callback) {
        if (!intent.hasExtra("audio.mills")) {
            intent.putExtra("audio.mills", System.currentTimeMillis());
        }
        this.mLongSpeech = intent.getIntExtra("vad.endpoint-timeout", -1) == 0;
        JSONObject jSONObject = this.convertIntentToJson(intent);
        try {
            this.mUsingListener.setCallbackListener(callback);
            int n = intent.getIntExtra("decoder", 0);
            if (n != 0) {
                this.mEventManagerAsr.send("asr.kws.load", jSONObject.toString(4), null, 0, 0);
            }
            this.mEventManagerAsr.send("asr.start", jSONObject.toString(4), null, 0, 0);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    protected void onStopListening(RecognitionService.Callback callback) {
        this.mEventManagerAsr.send("asr.stop", "{}", null, 0, 0);
    }

    protected void onCancel(RecognitionService.Callback callback) {
        this.mEventManagerAsr.send("asr.cancel", "{}", null, 0, 0);
    }

    public void onDestroy() {
        this.mEventManagerAsr.send("asr.kws.unload", "{}", null, 0, 0);
        super.onDestroy();
    }

    class MyListener
    implements EventListener {
        RecognitionService.Callback mListener;

        MyListener() {
        }

        public void setCallbackListener(RecognitionService.Callback callback) {
            this.mListener = callback;
        }

        public void onEvent(String string, String string2, byte[] byArray, int n, int n2) {
            RecognitionService.Callback callback = this.mListener;
            if (callback == null) {
                return;
            }
            try {
                if ("asr.ready".equals(string)) {
                    callback.readyForSpeech(new Bundle());
                } else if ("asr.begin".equals(string)) {
                    callback.beginningOfSpeech();
                } else if ("asr.audio".equals(string)) {
                    callback.bufferReceived(byArray);
                } else if ("asr.volume".equals(string)) {
                    JSONObject jSONObject = new JSONObject(string2);
                    double d = jSONObject.optDouble("volume");
                    callback.rmsChanged((float)d);
                } else if ("asr.end".equals(string)) {
                    callback.endOfSpeech();
                } else if ("asr.partial".equals(string)) {
                    JSONObject jSONObject = new JSONObject(string2);
                    String string3 = jSONObject.optString("result_type");
                    Bundle bundle = VoiceRecognitionService.fromJson(jSONObject);
                    if (string3 != null && string3 != "") {
                        if (string3.equals("partial_result")) {
                            callback.partialResults(bundle);
                        } else if (string3.equals("final_result")) {
                            VoiceRecognitionService.this.mFinalBundle = bundle;
                        } else if (string3.equals("third_result")) {
                            Bundle bundle2 = new Bundle();
                            bundle2.putByteArray("third_data", byArray);
                            this.callbackOnEvent(callback, 12, bundle2);
                        }
                    }
                } else if ("asr.finish".equals(string)) {
                    JSONObject jSONObject = new JSONObject(string2);
                    int n3 = jSONObject.getInt("error");
                    if (n3 != 0) {
                        callback.error(n3);
                        Bundle bundle = new Bundle();
                        bundle.putInt("error", jSONObject.getInt("sub_error"));
                        bundle.putString("reason", jSONObject.getString("desc"));
                        this.callbackOnEvent(callback, 11, bundle);
                    } else if (!VoiceRecognitionService.this.mLongSpeech) {
                        callback.results(VoiceRecognitionService.this.mFinalBundle);
                        VoiceRecognitionService.this.mFinalBundle = null;
                    }
                } else if ("asr.long-speech.finish".equals(string)) {
                    callback.results(VoiceRecognitionService.this.mFinalBundle);
                    VoiceRecognitionService.this.mFinalBundle = null;
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }

        private final void callbackOnEvent(RecognitionService.Callback callback, int n, Bundle bundle) {
            try {
                Field field = callback.getClass().getDeclaredField("mListener");
                field.setAccessible(true);
                Class<?> clazz = Class.forName("android.speech.IRecognitionListener");
                Method method = clazz.getMethod("onEvent", Integer.TYPE, Bundle.class);
                method.invoke(field.get(callback), n, bundle);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.log(Level.WARNING, "", exception);
            }
        }
    }
}

